files=uipickfiles('prompt','pick datafile','Filterspec','data/*.hpl');
nfiles=length(files);

SNR_thresh=1.02;
for jfiles=1:nfiles
     fid=fopen(char(files(jfiles)));
     lidar=read_Proc_profiles(fid,0.0);
     fclose(fid);

    
    vad=lidar;
    vad.number_of_gates=lidar.number_of_gates-14;
    vad.ranges=lidar.ranges(15:end);
    vad.RWS=lidar.RWS(:,15:end);
    vad.SNR=lidar.SNR(:,15:end);
    vad.Beta=lidar.Beta(:,15:end);
    vad.xd=lidar.xd(:,15:end);
    vad.yd=lidar.yd(:,15:end);
    vad.zd=lidar.zd(:,15:end);
    vad.azimuth=lidar.azimuth(:,15:end);
    vad.elevation=lidar.elevation(:,15:end);
    [na nr]=size(vad.RWS);

    [inda,indb]=size(vad.SNR);
    numble=inda*indb;
    snr=reshape(vad.SNR,numble,1);
    rws=reshape(vad.RWS,numble,1);
    zd=reshape(vad.zd,numble,1);
    ele=reshape(vad.elevation,numble,1);
%    p=reshape(p,numble,1);
    ind=find(snr<SNR_thresh | abs(rws./cosd(ele+0.001))>15 );
    snr(ind)=NaN;
    rws(ind)=NaN;
    snr=reshape(snr,inda,indb);
    rws=reshape(rws,inda,indb);
    zd=reshape(zd,inda,indb);
    vad.SNR=snr;
    vad.RWS=rws;
  
    profile=vvp_regression(vad);
     profile.shear=sqrt(profile.vel(:,3).^2+profile.vel(:,4).^2);



    profile_plot

end